/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.Emulator;
import jace.config.ConfigurableField;
import jace.config.InvokableAction;
import jace.core.Computer;
import jace.core.Device;
import jace.core.Motherboard;
import jace.core.VideoWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class Video
extends Device {
    BufferedImage video;
    VideoWriter currentWriter;
    Graphics screen;
    private byte floatingBus = 0;
    private int width = 560;
    private int height = 192;
    private int x = 0;
    protected int y = 0;
    public static final int CYCLES_PER_LINE = 65;
    public static final int TOTAL_LINES = 262;
    public static final int APPLE_CYCLES_PER_LINE = 40;
    public static final int APPLE_SCREEN_LINES = 192;
    public static final int HBLANK = 25;
    public static final int VBLANK = 4550;
    int vPeriod = 0;
    int hPeriod = 0;
    public static int[] textOffset;
    public static int[] hiresOffset;
    public static int[] textRowLookup;
    public static int[] hiresRowLookup;
    private boolean screenDirty;
    private boolean lineDirty;
    private boolean isVblank = false;
    static VideoWriter[][] writerCheck;
    private int forceRedrawRowCount = 0;
    Thread updateThread;
    @ConfigurableField(category="video", name="Min. Screen Refesh", defaultValue="15", description="Minimum number of miliseconds to wait before trying to redraw.")
    public static int MIN_SCREEN_REFRESH;
    int scannerAddress;
    @ConfigurableField(name="Waits per cycle", category="Advanced", description="Adjust the delay for the scanner")
    public static int waitsPerCycle;
    @ConfigurableField(name="Hblank X offset", category="Advanced", description="Adjust where the hblank period starts relative to the start of the line")
    public static int hblankOffsetX;
    @ConfigurableField(name="Hblank Y offset", category="Advanced", description="Adjust which line the HBLANK starts on (0=current, 1=next, etc)")
    public static int hblankOffsetY;

    public Video() {
        this.suspend();
        this.video = new BufferedImage(560, 192, 1);
        this.vPeriod = 0;
        this.hPeriod = 0;
        this.forceRefresh();
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setScreen(Graphics g) {
        this.screen = g;
    }

    public Graphics getScreen() {
        return this.screen;
    }

    public VideoWriter getCurrentWriter() {
        return this.currentWriter;
    }

    public void setCurrentWriter(VideoWriter currentWriter) {
        if (this.currentWriter != currentWriter || currentWriter.isMixed()) {
            this.currentWriter = currentWriter;
            this.forceRedrawRowCount = 193;
        }
    }

    public void redraw() {
        if (this.screen == null || this.video == null) {
            return;
        }
        this.screenDirty = false;
        this.screen.drawImage(this.video, 0, 0, this.width, this.height, null);
        if (Emulator.getFrame() != null) {
            Emulator.getFrame().repaintIndicators();
        }
    }

    public void vblankStart() {
        if (this.screenDirty && this.isRunning()) {
            this.redraw();
        }
    }

    public abstract void vblankEnd();

    public abstract void hblankStart(BufferedImage var1, int var2, boolean var3);

    public void setScannerLocation(int loc) {
        this.scannerAddress = loc;
    }

    @Override
    public void tick() {
        this.setFloatingBus(Computer.getComputer().getMemory().readRaw(this.scannerAddress + this.x));
        if (this.hPeriod > 0) {
            --this.hPeriod;
            if (this.hPeriod == 0) {
                this.x = -1;
                this.setScannerLocation(this.currentWriter.getYOffset(this.y));
            }
        } else {
            if (!this.isVblank) {
                this.draw();
            }
            if (this.x >= 39) {
                int yy = this.y + hblankOffsetY;
                if (yy < 0) {
                    yy += 192;
                }
                if (yy >= 192) {
                    yy -= 70;
                }
                this.setScannerLocation(this.currentWriter.getYOffset(yy) + hblankOffsetX + (yy < 64 ? 128 : 0));
                this.x = -1;
                if (!this.isVblank) {
                    if (this.lineDirty) {
                        this.screenDirty = true;
                        this.currentWriter.clearDirty(this.y);
                    }
                    this.hblankStart(this.video, this.y, this.lineDirty);
                    this.lineDirty = false;
                    --this.forceRedrawRowCount;
                }
                this.hPeriod = 25;
                ++this.y;
                if (this.y >= 192) {
                    if (!this.isVblank) {
                        this.y = 122;
                        this.isVblank = true;
                        this.vblankStart();
                        Motherboard.vblankStart();
                    } else {
                        this.y = 0;
                        this.isVblank = false;
                        this.vblankEnd();
                        Motherboard.vblankEnd();
                    }
                }
            }
        }
        ++this.x;
    }

    public abstract void configureVideoMode();

    protected static int byteDoubler(byte b) {
        int num = (b & 0x40) << 6 | (b & 0x20) << 5 | (b & 0x10) << 4 | (b & 8) << 3 | (b & 4) << 2 | (b & 2) << 1 | b & 1;
        return num | num << 1;
    }

    private void draw() {
        if (this.lineDirty || this.forceRedrawRowCount > 0 || this.currentWriter.isRowDirty(this.y)) {
            this.lineDirty = true;
            this.currentWriter.displayByte(this.video, this.x, this.y, textOffset[this.y], hiresOffset[this.y]);
        }
        this.setWaitCycles(waitsPerCycle);
        this.doPostDraw();
    }

    public static int calculateHiresOffset(int y) {
        return Video.calculateTextOffset(y >> 3) + ((y & 7) << 10);
    }

    public static int calculateTextOffset(int y) {
        return ((y & 7) << 7) + 40 * (y >> 3);
    }

    public static int identifyTextRow(int y) {
        return (y >> 7) + ((y & 0x7F) / 40 << 3);
    }

    public static int identifyHiresRow(int y) {
        int blockOffset = Video.identifyTextRow(y & 0x3FF);
        if (blockOffset > 23) {
            return -1;
        }
        return (y >> 10 & 7) + (blockOffset << 3);
    }

    public abstract void doPostDraw();

    public byte getFloatingBus() {
        return this.floatingBus;
    }

    private void setFloatingBus(byte floatingBus) {
        this.floatingBus = floatingBus;
    }

    @InvokableAction(name="Refresh screen", category="display", description="Marks screen contents as changed, forcing full screen redraw", alternatives="redraw")
    public void forceRefresh() {
        this.lineDirty = true;
        this.screenDirty = true;
        this.forceRedrawRowCount = 193;
    }

    @Override
    public String getShortName() {
        return "vid";
    }

    static {
        int i;
        writerCheck = new VideoWriter[40][192];
        textOffset = new int[192];
        hiresOffset = new int[192];
        textRowLookup = new int[1024];
        hiresRowLookup = new int[8192];
        for (i = 0; i < 192; ++i) {
            Video.textOffset[i] = Video.calculateTextOffset(i >> 3);
            Video.hiresOffset[i] = Video.calculateHiresOffset(i);
        }
        for (i = 0; i < 1024; ++i) {
            Video.textRowLookup[i] = Video.identifyTextRow(i);
        }
        for (i = 0; i < 8192; ++i) {
            Video.hiresRowLookup[i] = Video.identifyHiresRow(i);
        }
        MIN_SCREEN_REFRESH = 15;
        waitsPerCycle = 0;
        hblankOffsetX = -29;
        hblankOffsetY = 1;
    }
}

